function FFT_Analyzer  
% FFT Analyzer

  global fs
  global nbits
  global channels
  global IDin
  global audioInputName
  global audioOutputName
  global f 
  global sfontsize
  global isCancelMeasurement 
  global persParamsDir 
  global hdt
  
  % caculate aux parameters
  
  
  nfft = 16384;              % FFT length in samples   
  df= fs/nfft;               % Bin width          
  tfft=1/df;                 % FFT length in seconds
  
  t = 0:nfft-1;
  t = t/nfft;
  w = ones(1,nfft);
  w = w - 1.369982695 * cos(2*pi*t);
  w = w + 0.405410267 * cos(4*pi*t);
  w = w - 0.035427582 * cos(6*pi*t); % 4 term Nuttall window
  
  knbw=mean(w.*w);              % Noise bandwidth / df
  
  fa=f(1);
  fb=f(end);
  
  ia = round(fa/df); 
  da = fa/df - ia;
  wa = 0.5 - da;              %  weight of first bin for channel power
  ia = ia -1;                 %  use one bin more for spectrum display
                       
  ib=round(fb/df);
  db = fb/df -ib;
  wb = 0.5 + db;              %  weight of last bin  for channel power                            
  ib = ib +1;                 %  use one bin more for spectrum display
  
  ff=ia:ib;               
  ff=ff*df;   
  
  % set up audio device and start recording
  
  devinfo = audiodevinfo ();

  c=struct2cell(devinfo.input);
  c=c(1,1,:);
  selAidef=1;
  for i =1:length(c);
    isName=strcmpi(c(1,1,i),audioInputName);
    if isName
      selAidef=i;
    end
  end
  audioInputName = c{1,1,selAidef};
  
  sn = strcat(persParamsDir,'audioDevice.mat');
  save('-mat',sn,'audioInputName','audioOutputName');
  
  IDin = audiodevinfo(1,audioInputName);
  
  recorder = audiorecorder (fs, nbits, channels, IDin);
 
  record(recorder)
  pause(tfft)  
 
  
  % Prepare plots
  
  if ishandle(hdt) 
      delete(hdt); 
  end;
  subplot(1,1,1); 
  ha=gca();
  
  
  % Measure and display spectra until user cancels 
  
  isCancelMeasurement = false;
  
  while ~isCancelMeasurement
    
    % get new record
    
    pause(1.25*tfft);    
    
    stop(recorder);
    rx  = getaudiodata(recorder);
    rx= rx(1+nfft/4:nfft+nfft/4,2)';     
    record(recorder)
    
    % Overdrive detector 
    
    peak=max(abs(rx));
    Lpk=20*log10(peak);
    if Lpk < -0.001
      odstr=strcat('');
    else  
      odstr=cstrcat('Overdriven!');      
    end  
    
    % Spectrum  
    
    rx=rx.*w;
    U=fft(rx)/nfft;
    U=2*U(ia+1:ib+1);    
    L=20*log10(abs(U)+1e-40);     
   
    % RMS Level (20 Hz  ... 20 kHz)
     
    Pwr=abs(U.^2);
    Pwr(2)=wa*Pwr(2);
    Pwr(end-1)=wb*Pwr(end-1);
    ChPwr=sum(Pwr(2:end-1))/ knbw;    % channel power with nbw correction
    Lrms=10*log10(ChPwr);  
    
    % Interpolating peak finder
    
    [Lmax, imax]=max(L);    
    if (imax == 1)
      di=0;
      Lmax=L(imax);      
    elseif (imax == length(L))     
      di=0;
      Lmax=L(imax);      
    else 
      LM=L(imax-1);
      L0=L(imax+0);
      LP=L(imax+1);
      A1=(LP-LM)/2;
      A2=(LP+LM)/2-L0;
      if (A2 <0)
        di =-A1/2/A2;  
        Lmax=L0+A1*di+A2*di*di;
      else
        di = 0;
        Lmax = L0;
      end
    end
    
    dLk = di^2 * (- 0.1560 + 0.1315 * di^2); % correction for Nuttall window
    Lmax = Lmax + dLk;     
    di_k = di * (0.98373 + 0.06468 * di^2);  % correction for Nuttall window   
    fmax = ff(imax) + di_k * df;
    
    % Display results  if  sill not canceled
    
    if ~isCancelMeasurement && ishandle(ha)
      
      semilogx(ff,L)
      axis([fa fb -160 10]);  
      grid  
      title('Spectrum')    
      xlabel('Frequency / Hz');
      ylabel('L / dBFS');      
      
      ht1=text(25,5,['Lrms = ' num2str(Lrms,4) ' dBFS']);
      ht2=text(250,5,['Lpeak = ',num2str(Lmax,4'),' dBFS']);
      ht3=text(2500,5,['Fpeak = ',num2str(fmax,5'),' Hz']);      
      ht4=text(fmax,Lmax,'<peak');
      ht5=text(25,-15,odstr);
      set(ha,  'fontsize',sfontsize);    
      set(ht1, 'fontsize',sfontsize);
      set(ht2, 'fontsize',sfontsize);
      set(ht3, 'fontsize',sfontsize);
      set(ht4, 'fontsize',sfontsize);
      set(ht5, 'fontsize',sfontsize);
      
    end
    
  end 
  
  % Stop recording
  
  stop(recorder)
  
end